/*
 * written by Steven Chaitoff
 */



/*
 * GENERAL FUNCTIONS
 */


// important, often used flags
dashboard_open = true;	// indicates whether or not dashboard is open
expanded = false;	// indicates if widget is expanded to show a preview or not
busy = false;	// indicates if the widget is idling or doing something


optext = ''; // optext is span on face of widget that displays status to user


function setup() { // widget onload handler
	chain_document_elements();
	localize_strings();
	webkit_version();
	Preferences.load();
	optext.innerText = optext_main_status();
}



function desc(mode) { // onmouseover handler outputs short status explanations
	if (busy) return 0;
	var str;
	switch (mode) {
	case 'full': str='full_screen_grab'; break;
	case 'time': str='timed_grab'; break;
	case 'wndw': str='grab_a_window'; break;
	case 'wdgt': str='grab_a_widget'; break;
	case 'drag': str='drag_a_picture'; break;
	case 'rjct': str='reject'; break;
	case 'redo': str='redo'; break;
	case 'save': str='save_to'; break;
	case 'xprt': str='export_to'; break;
	}
	if (str) {
		str = localize(str);
		if (mode == 'save')	str += Preferences.save_loc_name();
		else if (mode == 'xprt') str += Preferences.export_app_name();
	}
	else str = expanded ? localize('screen_capture_preview') : optext_main_status();
	optext.innerText = str;
}



function optext_main_status() {
	var str = '';
	if (Preferences.save_location == Preferences.save_locations[0])	{
		optext.title = '';
		return localize('saving_to_the') + localize('clipboard') + localize('ja_saving_to');
	}	
	switch (Preferences.after_capture) {
	case Preferences.after_captures[3]: // save & open
		optext.title = localize('saving_to') + Preferences.save_path + localize('ja_saving_to') + '; ' + 
		localize('exporting_to') + Preferences.export_app + localize('ja_exporting_to');
		str = localize('saving_and_exporting');
		break;
	case Preferences.after_captures[2]: // open
		optext.title = localize('exporting_to') + Preferences.export_app + localize('ja_exporting_to');
		str = localize('exporting_to') + System.display_name(Preferences.export_app) + localize('ja_exporting_to');
		break;
	case Preferences.after_captures[1]:// save
		optext.title = localize('saving_to') + Preferences.save_path + localize('ja_saving_to');
		str = localize('saving_to') + System.display_name(Preferences.save_path) + localize('ja_saving_to');
		break;
	}
	return str;
}



function chain_document_elements() {
	optext = document.getElementById('optext');
	Stretcher.face = document.getElementById('front').style;
	Context.canvas = document.getElementById('zoomcanvas');
	Context.capture = document.getElementById('capture');
	Context.loupe = document.getElementById('loupe');
	Context.reflection = document.getElementById('reflection');
	Context.ctx = Context.canvas.getContext('2d');
	Context.img = Context.capture.style;
}



function localize_strings() {
	document.getElementById('pref_save_path').innerText = '/';
	document.getElementById('label_save_loc').innerText = localize('save_files_to');
	document.getElementById('label_save_name').innerText = localize('save_captures_as');
	document.getElementById('label_export_app').innerText = localize('export_captures_to');
	document.getElementById('label_after_capture').innerText = localize('after_capturing');
	document.getElementById('label_format').innerText = localize('format_images_using');
	createGenericButton(document.getElementById('done'), localize('done'), hidePrefs);
}



function webkit_version() {
	var user_agent = navigator.userAgent;
	if (!user_agent) return;
	var webkit_version = user_agent.indexOf('AppleWebKit') + 12;
	if (parseInt(user_agent.substr(webkit_version)) >= 500) { // if webkit is a Leopard version
		document.getElementById('input_save_name').style.backgroundColor = 'transparent';
	}
}



// language support
function localize(key) {
	var r = localized[key];
	return r ? r : '';
}



function swap_modes() { // displays appropriate "mode" icons after widget is finished stretching/compressing
	expanded = !expanded;
	document.getElementById('afterbuttons').style.display = expanded ? 'block' : 'none';
	document.getElementById('beforebuttons').style.display = expanded ? 'none' : 'block';
	optext.innerText = expanded ? localize('screen_capture_preview') : optext_main_status();
}



function flip_icon_display(d) { // shows or hides the 'fliprollie'
	document.getElementById('flip').style.display = d ? 'block' : 'none';
}



// allow more than one copy of this widget
function createKey(key) {
	return widget.identifier + '-' + key;
}



function browser_link() {
	if (widget) widget.openURL('http://www.columbia.edu/~slc2111/');
}







if (window.widget) {
	widget.onshow = function() { dashboard_open = true; };
	widget.onhide = function() { dashboard_open = false; };
}

window.onblur = function() { if (optext && !busy) optext.innerText = optext_main_status(); };








/*
* TRANSITION TO BACK (Apple code with minor changes)
*/


function showPrefs() {
	window.resizeTo(Stretcher.widget_width, Stretcher.max);
	if (window.widget) widget.prepareForTransition("ToBack");
	document.getElementById('front').style.display = 'none';
	document.getElementById('back').style.display = 'block';
	if (window.widget) setTimeout ('widget.performTransition();', 0);
	document.getElementById('fliprollie').style.display = 'none';
}



function hidePrefs() {
	Preferences.save();
	if (window.widget) widget.prepareForTransition("ToFront");
	document.getElementById('front').style.display = 'block';
	document.getElementById('back').style.display = 'none';
	if (window.widget) setTimeout ('widget.performTransition();', 0);
	window.resizeTo(Stretcher.widget_width, Stretcher.min);
	desc();
}



var flipShown = false;
var animation = {duration:0, starttime:0, to:1.0, now:0.0, from:0.0, firstElement:null, timer:null};

function mousemove (event)
{
	if (!flipShown)
	{
		if (animation.timer != null)
		{
			clearInterval (animation.timer);
			animation.timer  = null;
		}
		
		var starttime = (new Date).getTime() - 13; 		// set it back one frame
		
		animation.duration = 500;												// animation time, in ms
		animation.starttime = starttime;										// specify the start time
		animation.firstElement = document.getElementById ('flip');		// specify the element to fade
		animation.timer = setInterval ("animate();", 13);						// set the animation function
		animation.from = animation.now;											// beginning opacity (not ness. 0)
		animation.to = 1.0;														// final opacity
		animate();																// begin animation
		flipShown = true;														// mark the flipper as animated
	}
}



function mouseexit (event) {
	if (flipShown) {
		if (animation.timer != null) {
			clearInterval (animation.timer);
			animation.timer  = null;
		}
		var starttime = (new Date).getTime() - 13;
		animation.duration = 500;
		animation.starttime = starttime;
		animation.firstElement = document.getElementById ('flip');
		animation.timer = setInterval ("animate();", 13);
		animation.from = animation.now;
		animation.to = 0.0;
		animate();
		flipShown = false;
	}
}



function animate() {
	var ease;
	var time = (new Date).getTime();
	var T = limit_3(time-animation.starttime, 0, animation.duration);
	
	if (T >= animation.duration) {
		clearInterval (animation.timer);
		animation.timer = null;
		animation.now = animation.to;
	}
	else {
		ease = 0.5 - (0.5 * Math.cos(Math.PI * T / animation.duration));
		animation.now = computeNextFloat (animation.from, animation.to, ease);
	}
	animation.firstElement.style.opacity = animation.now;
}

function limit_3 (a, b, c) {
    return a < b ? b : (a > c ? c : a);
}

function computeNextFloat (from, to, ease) {
    return from + (to - from) * ease;
}

function enterflip(event) {
	document.getElementById('fliprollie').style.display = 'block';
}

function exitflip(event) {
	document.getElementById('fliprollie').style.display = 'none';
}

